{ *********************************************************************** }
{                                                                         }
{ Translated Header File                                                  }
{ Part of the Delphi Visual Component Library                             }
{                                                                         }
{ Original Header File Copyright (c) 1985-2004 Microsoft Corporation      }
{  All Rights Reserved.                                                   }
{                                                                         }
{ Obtained on behalf of Borland through:                                  }
{  Joint Endeavour of Delphi Innovators (JEDI)                            }
{  Website: http://www.delphi-jedi.org                                    }
{  Translator: Rudolph Velthuis                                           }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.UrlMon platform;

interface

uses System.Runtime.InteropServices, System.Text, Windows, ActiveX;

type
  [ComImport,
  GuidAttribute('79eac9c0-baf9-11ce-8c82-00aa004ba90b')]
  IBinding = interface
    function Abort: HResult;
    function Suspend: HResult;
    function Resume: HResult;
    function SetPriority(nPriority: Longint): HResult;
    function GetPriority(out nPriority: Longint): HResult;
    function GetBindResult(out clsidProtocol: TCLSID; out dwResult: DWORD;
      out szResult: string; dwReserved: DWORD): HResult;
  end;

const
  BINDVERB_GET    = $00000000;
  BINDVERB_POST   = $00000001;
  BINDVERB_PUT    = $00000002;
  BINDVERB_CUSTOM = $00000003;

  BINDINFOF_URLENCODESTGMEDDATA  = $00000001;
  BINDINFOF_URLENCODEDEXTRAINFO  = $00000002;

  BINDF_ASYNCHRONOUS             = $00000001;
  BINDF_ASYNCSTORAGE             = $00000002;
  BINDF_NOPROGRESSIVERENDERING   = $00000004;
  BINDF_OFFLINEOPERATION         = $00000008;
  BINDF_GETNEWESTVERSION         = $00000010;
  BINDF_NOWRITECACHE             = $00000020;
  BINDF_NEEDFILE                 = $00000040;
  BINDF_PULLDATA                 = $00000080;
  BINDF_IGNORESECURITYPROBLEM    = $00000100;
  BINDF_RESYNCHRONIZE            = $00000200;
  BINDF_HYPERLINK                = $00000400;
  BINDF_NO_UI                    = $00000800;
  BINDF_SILENTOPERATION          = $00001000;
  BINDF_PRAGMA_NO_CACHE          = $00002000;
  BINDF_FREE_THREADED            = $00010000;
  BINDF_DIRECT_READ              = $00020000;
  BINDF_FORMS_SUBMIT             = $00040000;
  BINDF_GETFROMCACHE_IF_NET_FAIL = $00080000;
  
  // These are for backwards compatibility with previous URLMON versions 
  BINDF_DONTUSECACHE             = BINDF_GETNEWESTVERSION;
  BINDF_DONTPUTINCACHE           = BINDF_NOWRITECACHE;
  BINDF_NOCOPYDATA               = BINDF_PULLDATA;

  BSCF_FIRSTDATANOTIFICATION        = $00000001;
  BSCF_INTERMEDIATEDATANOTIFICATION = $00000002;
  BSCF_LASTDATANOTIFICATION         = $00000004;
  BSCF_DATAFULLYAVAILABLE           = $00000008;
  BSCF_AVAILABLEDATASIZEUNKNOWN     = $00000010;

  BINDSTATUS_FINDINGRESOURCE           = 1;
  BINDSTATUS_CONNECTING                = BINDSTATUS_FINDINGRESOURCE + 1;
  BINDSTATUS_REDIRECTING               = BINDSTATUS_CONNECTING + 1;
  BINDSTATUS_BEGINDOWNLOADDATA         = BINDSTATUS_REDIRECTING + 1;
  BINDSTATUS_DOWNLOADINGDATA           = BINDSTATUS_BEGINDOWNLOADDATA + 1;
  BINDSTATUS_ENDDOWNLOADDATA           = BINDSTATUS_DOWNLOADINGDATA + 1;
  BINDSTATUS_BEGINDOWNLOADCOMPONENTS   = BINDSTATUS_ENDDOWNLOADDATA + 1;
  BINDSTATUS_INSTALLINGCOMPONENTS      = BINDSTATUS_BEGINDOWNLOADCOMPONENTS + 1;
  BINDSTATUS_ENDDOWNLOADCOMPONENTS     = BINDSTATUS_INSTALLINGCOMPONENTS + 1;
  BINDSTATUS_USINGCACHEDCOPY           = BINDSTATUS_ENDDOWNLOADCOMPONENTS + 1;
  BINDSTATUS_SENDINGREQUEST            = BINDSTATUS_USINGCACHEDCOPY + 1;
  BINDSTATUS_CLASSIDAVAILABLE          = BINDSTATUS_SENDINGREQUEST + 1;
  BINDSTATUS_MIMETYPEAVAILABLE         = BINDSTATUS_CLASSIDAVAILABLE + 1;
  BINDSTATUS_CACHEFILENAMEAVAILABLE    = BINDSTATUS_MIMETYPEAVAILABLE + 1;
  BINDSTATUS_BEGINSYNCOPERATION        = BINDSTATUS_CACHEFILENAMEAVAILABLE + 1;
  BINDSTATUS_ENDSYNCOPERATION          = BINDSTATUS_BEGINSYNCOPERATION + 1;
  BINDSTATUS_BEGINUPLOADDATA           = BINDSTATUS_ENDSYNCOPERATION + 1;
  BINDSTATUS_UPLOADINGDATA             = BINDSTATUS_BEGINUPLOADDATA + 1;
  BINDSTATUS_ENDUPLOADDATA             = BINDSTATUS_UPLOADINGDATA + 1;
  BINDSTATUS_PROTOCOLCLASSID           = BINDSTATUS_ENDUPLOADDATA + 1;
  BINDSTATUS_ENCODING                  = BINDSTATUS_PROTOCOLCLASSID + 1;
  BINDSTATUS_VERIFIEDMIMETYPEAVAILABLE = BINDSTATUS_ENCODING + 1;
  BINDSTATUS_CLASSINSTALLLOCATION      = BINDSTATUS_VERIFIEDMIMETYPEAVAILABLE + 1;
  BINDSTATUS_DECODING                  = BINDSTATUS_CLASSINSTALLLOCATION + 1;
  BINDSTATUS_LOADINGMIMEHANDLER        = BINDSTATUS_DECODING + 1;
  BINDSTATUS_CONTENTDISPOSITIONATTACH = BINDSTATUS_LOADINGMIMEHANDLER + 1;
  BINDSTATUS_FILTERREPORTMIMETYPE = BINDSTATUS_CONTENTDISPOSITIONATTACH + 1;
  BINDSTATUS_CLSIDCANINSTANTIATE = BINDSTATUS_FILTERREPORTMIMETYPE + 1;
  BINDSTATUS_IUNKNOWNAVAILABLE = BINDSTATUS_CLSIDCANINSTANTIATE + 1;
  BINDSTATUS_DIRECTBIND = BINDSTATUS_IUNKNOWNAVAILABLE + 1;
  BINDSTATUS_RAWMIMETYPE = BINDSTATUS_DIRECTBIND + 1;
  BINDSTATUS_PROXYDETECTING = BINDSTATUS_RAWMIMETYPE + 1;
  BINDSTATUS_ACCEPTRANGES = BINDSTATUS_PROXYDETECTING + 1;
  BINDSTATUS_COOKIE_SENT = BINDSTATUS_ACCEPTRANGES + 1;
  BINDSTATUS_COMPACT_POLICY_RECEIVED      = BINDSTATUS_COOKIE_SENT + 1;
  BINDSTATUS_COOKIE_SUPPRESSED = BINDSTATUS_COMPACT_POLICY_RECEIVED + 1;
  BINDSTATUS_COOKIE_STATE_UNKNOWN = BINDSTATUS_COOKIE_SUPPRESSED + 1;
  BINDSTATUS_COOKIE_STATE_ACCEPT = BINDSTATUS_COOKIE_STATE_UNKNOWN + 1;
  BINDSTATUS_COOKIE_STATE_REJECT = BINDSTATUS_COOKIE_STATE_ACCEPT + 1;
  BINDSTATUS_COOKIE_STATE_PROMPT = BINDSTATUS_COOKIE_STATE_REJECT + 1;
  BINDSTATUS_COOKIE_STATE_LEASH = BINDSTATUS_COOKIE_STATE_PROMPT + 1;
  BINDSTATUS_COOKIE_STATE_DOWNGRADE = BINDSTATUS_COOKIE_STATE_LEASH + 1;
  BINDSTATUS_POLICY_HREF = BINDSTATUS_COOKIE_STATE_DOWNGRADE + 1;
  BINDSTATUS_P3P_HEADER = BINDSTATUS_POLICY_HREF + 1;
  BINDSTATUS_SESSION_COOKIE_RECEIVED = BINDSTATUS_P3P_HEADER + 1;
  BINDSTATUS_PERSISTENT_COOKIE_RECEIVED = BINDSTATUS_SESSION_COOKIE_RECEIVED + 1;
  BINDSTATUS_SESSION_COOKIES_ALLOWED = BINDSTATUS_PERSISTENT_COOKIE_RECEIVED + 1;

type
  _tagBINDINFO = packed record
    cbSize: ULONG;
    [MarshalAs(UnmanagedType.LPWStr)]
    szExtraInfo: string;
    stgmedData: TStgMedium;
    grfBindInfoF: DWORD;
    dwBindVerb: DWORD;
    [MarshalAs(UnmanagedType.LPWStr)]
    szCustomVerb: string;
    cbstgmedData: DWORD;
    dwOptions: DWORD;
    dwOptionsFlags: DWORD;
    dwCodePage: DWORD;
    securityAttributes: TSecurityAttributes;
    iid: TGUID;
    pUnk: IntPtr; { IUnknown }
    dwReserved: DWORD;
  end;
  TBindInfo = _tagBINDINFO;
  BINDINFO = _tagBINDINFO;

  [ComImport,
  GuidAttribute('79eac9c1-baf9-11ce-8c82-00aa004ba90b')]
  IBindStatusCallback = interface
    function OnStartBinding(dwReserved: DWORD; pib: IBinding): HResult;
    function GetPriority(out nPriority): HResult;
    function OnLowResource(reserved: DWORD): HResult;
    function OnProgress(ulProgress, ulProgressMax, ulStatusCode: ULONG;
      szStatusText: string): HResult;
    function OnStopBinding(hresult: HResult; szError: string): HResult;
    function GetBindInfo(out grfBINDF: DWORD; var bindinfo: TBindInfo): HResult;
    function OnDataAvailable(grfBSCF: DWORD; dwSize: DWORD; var formatetc: TFormatEtc;
      var stgmed: TStgMedium): HResult;
    function OnObjectAvailable([MarshalAs(UnmanagedType.LPStruct)] const iid: TGUID;
      punk: IntPtr {IUnknown}): HResult;
  end;

function URLDownloadToFile(Caller: IntPtr {IUnknown}; URL: string;
  FileName: string; Reserved: DWORD; StatusCB: IBindStatusCallback): HResult;
function URLDownloadToFileA(Caller: IntPtr {IUnknown}; URL: string;
  FileName: string; Reserved: DWORD; StatusCB: IBindStatusCallback): HResult;
function URLDownloadToFileW(Caller: IntPtr {IUnknown}; URL: string;
  FileName: string; Reserved: DWORD; StatusCB: IBindStatusCallback): HResult;
type
  _tagSOFTDISTINFO = packed record
    cbSize: ULONG;
    dwFlags: DWORD;
    dwAdState: DWORD;
    [MarshalAs(UnmanagedType.LPWStr)]
    szTitle: string;
    [MarshalAs(UnmanagedType.LPWStr)]
    szAbstract: string;
    [MarshalAs(UnmanagedType.LPWStr)]
    szHREF: string;
    dwInstalledVersionMS: DWORD;
    dwInstalledVersionLS: DWORD;
    dwUpdateVersionMS: DWORD;
    dwUpdateVersionLS: DWORD;
    dwAdvertisedVersionMS: DWORD;
    dwAdvertisedVersionLS: DWORD;
    dwReserved: DWORD;
  end;
  TSoftDistInfo = _tagSOFTDISTINFO;
  SOFTDISTINFO = _tagSOFTDISTINFO;

implementation

const
  UrlMonLib = 'URLMON.DLL';

[DllImport(UrlMonLib, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'URLDownloadToFile')]
function URLDownloadToFile; external;
[DllImport(UrlMonLib, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'URLDownloadToFileA')]
function URLDownloadToFileA; external;
[DllImport(UrlMonLib, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'URLDownloadToFileW')]
function URLDownloadToFileW; external;

end.
